/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.element.AnimatedOverlayElement;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.Pointing;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class InputWindowElement
extends AnimatedOverlayElement {
    private Pointing direction;
    class_2960 key;
    AllIcons icon;
    class_1799 item = class_1799.field_8037;
    private class_243 sceneSpace;

    public InputWindowElement clone() {
        InputWindowElement inputWindowElement = new InputWindowElement(this.sceneSpace, this.direction);
        inputWindowElement.key = this.key;
        inputWindowElement.icon = this.icon;
        inputWindowElement.item = this.item.method_7972();
        return inputWindowElement;
    }

    public InputWindowElement(class_243 sceneSpace, Pointing direction) {
        this.sceneSpace = sceneSpace;
        this.direction = direction;
    }

    public InputWindowElement withItem(class_1799 stack) {
        this.item = stack;
        return this;
    }

    public InputWindowElement withWrench() {
        this.item = AllItems.WRENCH.asStack();
        return this;
    }

    public InputWindowElement scroll() {
        this.icon = AllIcons.I_SCROLL;
        return this;
    }

    public InputWindowElement rightClick() {
        this.icon = AllIcons.I_RMB;
        return this;
    }

    public InputWindowElement showing(AllIcons icon) {
        this.icon = icon;
        return this;
    }

    public InputWindowElement leftClick() {
        this.icon = AllIcons.I_LMB;
        return this;
    }

    public InputWindowElement whileSneaking() {
        this.key = Create.asResource("sneak_and");
        return this;
    }

    public InputWindowElement whileCTRL() {
        this.key = Create.asResource("ctrl_and");
        return this;
    }

    @Override
    protected void render(PonderScene scene, PonderUI screen, class_332 graphics, float partialTicks, float fade) {
        String text;
        float xFade;
        class_327 font = screen.getFontRenderer();
        int width = 0;
        int height = 0;
        float f = this.direction == Pointing.RIGHT ? -1.0f : (xFade = this.direction == Pointing.LEFT ? 1.0f : 0.0f);
        float yFade = this.direction == Pointing.DOWN ? -1.0f : (this.direction == Pointing.UP ? 1.0f : 0.0f);
        xFade *= 10.0f * (1.0f - fade);
        yFade *= 10.0f * (1.0f - fade);
        boolean hasItem = !this.item.method_7960();
        boolean hasText = this.key != null;
        boolean hasIcon = this.icon != null;
        int keyWidth = 0;
        String string = text = hasText ? PonderLocalization.getShared(this.key) : "";
        if (fade < 0.0625f) {
            return;
        }
        class_241 sceneToScreen = scene.getTransform().sceneToScreen(this.sceneSpace, partialTicks);
        if (hasIcon) {
            width += 24;
            height = 24;
        }
        if (hasText) {
            keyWidth = font.method_1727(text);
            width += keyWidth;
        }
        if (hasItem) {
            width += 24;
            height = 24;
        }
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        ms.method_46416(sceneToScreen.field_1343 + xFade, sceneToScreen.field_1342 + yFade, 400.0f);
        PonderUI.renderSpeechBox(graphics, 0, 0, width, height, false, this.direction, true);
        ms.method_46416(0.0f, 0.0f, 100.0f);
        if (hasText) {
            Objects.requireNonNull(font);
            graphics.method_51433(font, text, 2, (int)((float)(height - 9) / 2.0f + 2.0f), PonderPalette.WHITE.getColorObject().scaleAlpha(fade).getRGB(), false);
        }
        if (hasIcon) {
            ms.method_22903();
            ms.method_46416((float)keyWidth, 0.0f, 0.0f);
            ms.method_22905(1.5f, 1.5f, 1.5f);
            this.icon.render(graphics, 0, 0);
            ms.method_22909();
        }
        if (hasItem) {
            ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.item).at(keyWidth + (hasIcon ? 24 : 0), 0.0f)).scale(1.5).render(graphics);
            RenderSystem.disableDepthTest();
        }
        ms.method_22909();
    }
}

